<?php
// test_worker.php
// Usage: php test_worker.php target rpm duration_minutes
// Örnek: php test_worker.php "http://127.0.0.1:8080/" 20 60

if ($argc < 4) {
    fwrite(STDERR, "Usage: php test_worker.php target rpm duration_minutes\n");
    exit(1);
}

$config = require __DIR__ . '/config.php';

$target = $argv[1];
$rpm = max(1, (int)$argv[2]);
$duration = max(1, (int)$argv[3]);

// Basit User-Agent havuzu — istersen genişlet
$uaPool = [
    "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/117.0.0.0 Safari/537.36",
    "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.1.2 Safari/605.1.15",
    "Mozilla/5.0 (iPhone; CPU iPhone OS 14_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.0 Mobile/15E148 Safari/604.1",
    "Mozilla/5.0 (Linux; Android 11; SM-G981B) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Mobile Safari/537.36",
    // isteğe bağlı daha fazla UA ekle
];

// Hedef host whitelist kontrolü (ek güvenlik)
$host = parse_url($target, PHP_URL_HOST);
if (!$host || !in_array($host, $config['whitelist'], true)) {
    file_put_contents($config['log_file'], "[".date('c')."] Hedef whitelist kontrolünden geçemedi: $target\n", FILE_APPEND);
    exit(1);
}

$intervalSec = 60 / $rpm; // dakikadaki istek sayısına göre ortalama aralığı saniye cinsinden
$endTime = time() + ($duration * 60);

// Log aç
$logFile = $config['log_file'];
$fpLog = fopen($logFile, 'a');

fwrite($fpLog, "[".date('c')."] Test başlıyor: target=$target rpm=$rpm duration_min=$duration\n");

while (time() < $endTime) {
    $iterStart = microtime(true);
    $ua = $uaPool[array_rand($uaPool)];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $target);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, false);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_USERAGENT, $ua);

    // PROXY EKLEME (Sadece izinli kullanım için):
    // Örnek (YASAK/TEHLİKELİ hedefler için kullanmayın): 
    // curl_setopt($ch, CURLOPT_PROXY, 'pr.oxylabs.io:7777');
    // curl_setopt($ch, CURLOPT_PROXYUSERPWD, 'customer-xxxx:password');

    $res = curl_exec($ch);
    $info = curl_getinfo($ch);
    $err = curl_error($ch);
    curl_close($ch);

    $status = $info['http_code'] ?? 0;
    $timeTotal = isset($info['total_time']) ? round($info['total_time'], 3) : 0;

    $logLine = "[".date('c')."] status={$status} time={$timeTotal}s UA=".substr($ua,0,60)." err=" . ($err ?: '-') . "\n";
    fwrite($fpLog, $logLine);

    // Ortalama aralık hesapla, fakat istek süresini hesaba kat
    $elapsed = microtime(true) - $iterStart;
    $sleepFor = $intervalSec - $elapsed;
    if ($sleepFor < 0) $sleepFor = 0;
    // ufak rastgelelik ekle (0..0.5s)
    $sleepFor += mt_rand(0, 500) / 1000;
    usleep((int)($sleepFor * 1000000));
}

fwrite($fpLog, "[".date('c')."] Test tamamlandı.\n");
fclose($fpLog);
exit(0);
